/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import jakarta.validation.constraints.NotEmpty;
import java.util.Map;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class IndexDefinition {
    @NotEmpty
    private String defaultAnalyzer;
    private Map<@NotEmpty String, @NotEmpty String> fieldAnalyzers;

    public IndexDefinition() {
    }

    public IndexDefinition(String defaultAnalyzer, Map<String, String> fieldAnalyzers) {
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = fieldAnalyzers;
    }

    @JsonProperty
    public String getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public void setDefaultAnalyzer(String defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    @JsonProperty
    public Map<String, String> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    public void setFieldAnalyzers(Map<String, String> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers;
    }

    public boolean hasFieldAnalyzers() {
        return this.fieldAnalyzers != null && !this.fieldAnalyzers.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultAnalyzer == null ? 0 : this.defaultAnalyzer.hashCode());
        result = 31 * result + (this.fieldAnalyzers == null ? 0 : this.fieldAnalyzers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinition other = (IndexDefinition)obj;
        if (this.defaultAnalyzer == null ? other.defaultAnalyzer != null : !this.defaultAnalyzer.equals(other.defaultAnalyzer)) {
            return false;
        }
        return !(this.fieldAnalyzers == null ? other.fieldAnalyzers != null : !this.fieldAnalyzers.equals(other.fieldAnalyzers));
    }

    public String toString() {
        return "IndexDefinition [defaultAnalyzer=" + this.defaultAnalyzer + ", fieldAnalyzers=" + String.valueOf(this.fieldAnalyzers) + "]";
    }
}

