/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Range<T> {
    @NotEmpty
    private String label;
    @NotNull
    private T min;
    private boolean minInclusive = true;
    @NotNull
    private T max;
    private boolean maxInclusive = true;

    public Range() {
    }

    public Range(String label, T min, boolean minInclusive, T max, boolean maxInclusive) {
        this.label = label;
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @JsonProperty
    public T getMin() {
        return this.min;
    }

    public void setMin(T min) {
        this.min = min;
    }

    @JsonProperty(value="min_inclusive")
    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    @JsonProperty
    public T getMax() {
        return this.max;
    }

    public void setMax(T max) {
        this.max = max;
    }

    @JsonProperty(value="max_inclusive")
    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.minInclusive ? 1231 : 1237);
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.maxInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        if (this.minInclusive != other.minInclusive) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return this.maxInclusive == other.maxInclusive;
    }

    public String toString() {
        return "Range [label=" + this.label + ", min=" + String.valueOf(this.min) + ", minInclusive=" + this.minInclusive + ", max=" + String.valueOf(this.max) + ", maxInclusive=" + this.maxInclusive + "]";
    }
}

