/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.apache.couchdb.nouveau.api.Field;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class StoredField
extends Field {
    @NotNull
    @Schema(oneOf={String.class, Double.class, byte[].class})
    private final Object value;

    public StoredField(@JsonProperty(value="name") String name, @JsonProperty(value="value") Object value) {
        super(name);
        if (!(value instanceof String || value instanceof Number || value instanceof byte[])) {
            throw new IllegalArgumentException(String.valueOf(value) + " must be a string, number or byte array");
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "StoredField [name=" + this.name + ", value=" + String.valueOf(this.value) + "]";
    }
}

