/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class IOUtils {
    public static void rm(Path path) throws IOException {
        File[] allContents = path.toFile().listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                IOUtils.rm(file.toPath());
            }
        }
        if (!path.toFile().delete()) {
            throw new IOException("failed to delete " + String.valueOf(path));
        }
    }

    public static void runAll(IORunnable ... runnables) throws IOException {
        Throwable thrown = null;
        for (IORunnable r : runnables) {
            try {
                r.run();
            }
            catch (Throwable e) {
                if (thrown != null) continue;
                thrown = e;
            }
        }
        if (thrown != null) {
            if (thrown instanceof IOException) {
                throw (IOException)thrown;
            }
            if (thrown instanceof RuntimeException) {
                throw (RuntimeException)thrown;
            }
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
        }
    }

    @FunctionalInterface
    public static interface IORunnable {
        public void run() throws IOException;
    }
}

