/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.core;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import org.apache.couchdb.nouveau.api.DocumentDeleteRequest;
import org.apache.couchdb.nouveau.api.DocumentUpdateRequest;
import org.apache.couchdb.nouveau.api.IndexInfo;
import org.apache.couchdb.nouveau.api.SearchRequest;
import org.apache.couchdb.nouveau.api.SearchResults;
import org.apache.couchdb.nouveau.core.StaleIndexException;
import org.apache.couchdb.nouveau.core.UpdatesOutOfOrderException;

public abstract class Index
implements Closeable {
    private long updateSeq;
    private long purgeSeq;
    private boolean deleteOnClose = false;

    protected Index(long updateSeq, long purgeSeq) {
        this.updateSeq = updateSeq;
        this.purgeSeq = purgeSeq;
    }

    public final IndexInfo info() throws IOException {
        int numDocs = this.doNumDocs();
        long diskSize = this.doDiskSize();
        return new IndexInfo(this.updateSeq, this.purgeSeq, numDocs, diskSize);
    }

    protected abstract int doNumDocs() throws IOException;

    protected abstract long doDiskSize() throws IOException;

    public final synchronized void update(String docId, DocumentUpdateRequest request) throws IOException {
        this.assertUpdateSeqProgress(request.getMatchSeq(), request.getSeq());
        this.doUpdate(docId, request);
        this.incrementUpdateSeq(request.getMatchSeq(), request.getSeq());
    }

    protected abstract void doUpdate(String var1, DocumentUpdateRequest var2) throws IOException;

    public final synchronized void delete(String docId, DocumentDeleteRequest request) throws IOException {
        if (request.isPurge()) {
            this.assertPurgeSeqProgress(request.getMatchSeq(), request.getSeq());
            this.doDelete(docId, request);
            this.incrementPurgeSeq(request.getMatchSeq(), request.getSeq());
        } else {
            this.assertUpdateSeqProgress(request.getMatchSeq(), request.getSeq());
            this.doDelete(docId, request);
            this.incrementUpdateSeq(request.getMatchSeq(), request.getSeq());
        }
    }

    protected abstract void doDelete(String var1, DocumentDeleteRequest var2) throws IOException;

    public final SearchResults search(SearchRequest request) throws IOException {
        this.assertMinSeqs(request.getMinUpdateSeq(), request.getMinPurgeSeq());
        return this.doSearch(request);
    }

    protected abstract SearchResults doSearch(SearchRequest var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commit() throws IOException {
        long purgeSeq;
        long updateSeq;
        Index index = this;
        synchronized (index) {
            if (this.deleteOnClose) {
                return false;
            }
            updateSeq = this.updateSeq;
            purgeSeq = this.purgeSeq;
        }
        return this.doCommit(updateSeq, purgeSeq);
    }

    protected abstract boolean doCommit(long var1, long var3) throws IOException;

    public final synchronized void setUpdateSeq(long matchSeq, long updateSeq) throws IOException {
        if (updateSeq < this.updateSeq) {
            throw new WebApplicationException("update_seq must be equal or greater than current update_seq", Response.Status.BAD_REQUEST);
        }
        if (updateSeq > this.updateSeq) {
            this.incrementUpdateSeq(matchSeq, updateSeq);
        }
    }

    public final synchronized void setPurgeSeq(long matchSeq, long purgeSeq) throws IOException {
        if (purgeSeq < this.purgeSeq) {
            throw new WebApplicationException("purge_seq must be equal or greater than current purge_seq", Response.Status.BAD_REQUEST);
        }
        if (purgeSeq > this.purgeSeq) {
            this.incrementPurgeSeq(matchSeq, purgeSeq);
        }
    }

    @Override
    public final void close() throws IOException {
        this.doClose();
    }

    protected abstract void doClose() throws IOException;

    public synchronized boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    public final boolean isOpen() {
        return this.doIsOpen();
    }

    protected abstract boolean doIsOpen();

    public synchronized void setDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose = deleteOnClose;
    }

    protected final void assertUpdateSeqProgress(long matchSeq, long updateSeq) throws UpdatesOutOfOrderException {
        assert (Thread.holdsLock(this));
        if (matchSeq != this.updateSeq) {
            throw new UpdatesOutOfOrderException(false, this.updateSeq, matchSeq, updateSeq);
        }
        if (updateSeq <= this.updateSeq) {
            throw new UpdatesOutOfOrderException(false, this.updateSeq, matchSeq, updateSeq);
        }
    }

    protected final void incrementUpdateSeq(long matchSeq, long updateSeq) throws IOException {
        assert (Thread.holdsLock(this));
        this.assertUpdateSeqProgress(matchSeq, updateSeq);
        this.updateSeq = updateSeq;
    }

    protected final void assertPurgeSeqProgress(long matchSeq, long purgeSeq) throws UpdatesOutOfOrderException {
        assert (Thread.holdsLock(this));
        if (matchSeq != this.purgeSeq) {
            throw new UpdatesOutOfOrderException(true, this.purgeSeq, matchSeq, purgeSeq);
        }
        if (purgeSeq <= this.purgeSeq) {
            throw new UpdatesOutOfOrderException(true, this.purgeSeq, matchSeq, purgeSeq);
        }
    }

    protected final void incrementPurgeSeq(long matchSeq, long purgeSeq) throws IOException {
        assert (Thread.holdsLock(this));
        this.assertPurgeSeqProgress(matchSeq, purgeSeq);
        this.purgeSeq = purgeSeq;
    }

    protected final void assertMinSeqs(long minUpdateSeq, long minPurgeSeq) throws StaleIndexException {
        if (this.updateSeq < minUpdateSeq) {
            throw new StaleIndexException(false, minUpdateSeq, this.updateSeq);
        }
        if (this.purgeSeq < minPurgeSeq) {
            throw new StaleIndexException(true, minPurgeSeq, this.purgeSeq);
        }
    }
}

