/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.core;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class StripedLock<K> {
    private final ReadWriteLock[] locks;

    public StripedLock(int lockCount) {
        this.locks = new ReadWriteLock[lockCount];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    public Lock readLock(K key) {
        return this.readWriteLock(key).readLock();
    }

    public Lock writeLock(K key) {
        return this.readWriteLock(key).writeLock();
    }

    private ReadWriteLock readWriteLock(K key) {
        return this.locks[Math.floorMod(key.hashCode(), this.locks.length)];
    }
}

