/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.lucene9;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.couchdb.nouveau.api.DocumentDeleteRequest;
import org.apache.couchdb.nouveau.api.DocumentUpdateRequest;
import org.apache.couchdb.nouveau.api.DoubleField;
import org.apache.couchdb.nouveau.api.DoubleRange;
import org.apache.couchdb.nouveau.api.Field;
import org.apache.couchdb.nouveau.api.SearchHit;
import org.apache.couchdb.nouveau.api.SearchRequest;
import org.apache.couchdb.nouveau.api.SearchResults;
import org.apache.couchdb.nouveau.core.IOUtils;
import org.apache.couchdb.nouveau.core.Index;
import org.apache.couchdb.nouveau.core.ser.ByteArrayWrapper;
import org.apache.couchdb.nouveau.core.ser.DoubleWrapper;
import org.apache.couchdb.nouveau.core.ser.FloatWrapper;
import org.apache.couchdb.nouveau.core.ser.IntWrapper;
import org.apache.couchdb.nouveau.core.ser.LongWrapper;
import org.apache.couchdb.nouveau.core.ser.NullWrapper;
import org.apache.couchdb.nouveau.core.ser.PrimitiveWrapper;
import org.apache.couchdb.nouveau.core.ser.StringWrapper;
import org.apache.couchdb.nouveau.lucene9.Lucene9IndexSchema;
import org.apache.couchdb.nouveau.lucene9.NouveauQueryParser;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.StringDocValuesReaderState;
import org.apache.lucene.facet.StringValueFacetCounts;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class Lucene9Index
extends Index {
    private static final Sort DEFAULT_SORT = new Sort(new SortField[]{SortField.FIELD_SCORE, new SortField("_id", SortField.Type.STRING)});
    private static final Pattern SORT_FIELD_RE = Pattern.compile("^([-+])?([\\.\\w]+)$");
    private final Analyzer analyzer;
    private final IndexWriter writer;
    private final SearcherManager searcherManager;
    private final Lucene9IndexSchema schema;

    public Lucene9Index(Analyzer analyzer, IndexWriter writer, long updateSeq, long purgeSeq, SearcherManager searcherManager) {
        super(updateSeq, purgeSeq);
        this.analyzer = Objects.requireNonNull(analyzer);
        this.writer = Objects.requireNonNull(writer);
        this.searcherManager = Objects.requireNonNull(searcherManager);
        this.schema = this.initSchema(writer);
    }

    @Override
    public int doNumDocs() throws IOException {
        return this.writer.getDocStats().numDocs;
    }

    @Override
    public long doDiskSize() throws IOException {
        Directory dir = this.writer.getDirectory();
        long result = 0L;
        for (String name : dir.listAll()) {
            try {
                result += dir.fileLength(name);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void doUpdate(String docId, DocumentUpdateRequest request) throws IOException {
        Term docIdTerm = Lucene9Index.docIdTerm(docId);
        Document doc = Lucene9Index.toDocument(docId, request);
        this.schema.update(request.getFields());
        this.writer.updateDocument(docIdTerm, (Iterable)doc);
    }

    @Override
    public void doDelete(String docId, DocumentDeleteRequest request) throws IOException {
        Query query = Lucene9Index.docIdQuery(docId);
        this.writer.deleteDocuments(new Query[]{query});
    }

    @Override
    public boolean doCommit(long updateSeq, long purgeSeq) throws IOException {
        if (!this.writer.hasUncommittedChanges()) {
            return false;
        }
        this.writer.setLiveCommitData(Map.of("update_seq", Long.toString(updateSeq), "purge_seq", Long.toString(purgeSeq), "_schema", this.schema.toString()).entrySet());
        this.writer.commit();
        return true;
    }

    @Override
    public void doClose() throws IOException {
        IOUtils.runAll(() -> this.searcherManager.close(), () -> this.writer.rollback(), () -> {
            if (this.isDeleteOnClose()) {
                Directory dir = this.writer.getDirectory();
                for (String name : dir.listAll()) {
                    dir.deleteFile(name);
                }
            }
        });
    }

    @Override
    public boolean doIsOpen() {
        return this.writer.isOpen();
    }

    @Override
    public SearchResults doSearch(SearchRequest request) throws IOException {
        Query query = this.parse(request);
        CollectorManager<?, ? extends TopDocs> hits = this.hitCollector(request);
        MultiCollectorManager cm = request.hasCounts() || request.hasRanges() ? new MultiCollectorManager(new CollectorManager[]{hits, new FacetsCollectorManager()}) : new MultiCollectorManager(new CollectorManager[]{hits});
        this.searcherManager.maybeRefreshBlocking();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Object[] reduces = (Object[])searcher.search(query, (CollectorManager)cm);
            SearchResults searchResults = this.toSearchResults(request, searcher, reduces);
            return searchResults;
        }
        catch (IllegalStateException e) {
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.BAD_REQUEST);
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    private CollectorManager<?, ? extends TopDocs> hitCollector(SearchRequest searchRequest) {
        FieldDoc fieldDoc;
        Sort sort = this.toSort(searchRequest);
        Object[] after = searchRequest.getAfter();
        if (after != null) {
            fieldDoc = this.toFieldDoc(after);
            fieldDoc.doc = this.getLastSortField(sort).getReverse() ? 0 : Integer.MAX_VALUE;
        } else {
            fieldDoc = null;
        }
        return new TopFieldCollectorManager(sort, searchRequest.getLimit(), fieldDoc, 1000);
    }

    private SortField getLastSortField(Sort sort) {
        SortField[] sortFields = sort.getSort();
        return sortFields[sortFields.length - 1];
    }

    private SearchResults toSearchResults(SearchRequest searchRequest, IndexSearcher searcher, Object[] reduces) throws IOException {
        SearchResults result = new SearchResults();
        this.collectHits(searcher, (TopDocs)reduces[0], result);
        if (reduces.length == 2) {
            this.collectFacets(searchRequest, searcher, (FacetsCollector)reduces[1], result);
        }
        return result;
    }

    private void collectHits(IndexSearcher searcher, TopDocs topDocs, SearchResults searchResults) throws IOException {
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>(topDocs.scoreDocs.length);
        StoredFields storedFields = searcher.storedFields();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            Document doc = storedFields.document(scoreDoc.doc);
            ArrayList<org.apache.couchdb.nouveau.api.StoredField> fields = new ArrayList<org.apache.couchdb.nouveau.api.StoredField>(doc.getFields().size());
            block6: for (IndexableField field : doc.getFields()) {
                if (field.name().equals("_id")) continue;
                StoredValue storedValue = field.storedValue();
                switch (storedValue.getType()) {
                    case DOUBLE: {
                        fields.add(new org.apache.couchdb.nouveau.api.StoredField(field.name(), storedValue.getDoubleValue()));
                        continue block6;
                    }
                    case STRING: {
                        fields.add(new org.apache.couchdb.nouveau.api.StoredField(field.name(), storedValue.getStringValue()));
                        continue block6;
                    }
                    case BINARY: {
                        fields.add(new org.apache.couchdb.nouveau.api.StoredField(field.name(), storedValue.getBinaryValue()));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException(String.valueOf(storedValue.getType()) + " not supported");
            }
            PrimitiveWrapper<?>[] after = this.toAfter((FieldDoc)scoreDoc);
            hits.add(new SearchHit(doc.get("_id"), after, fields));
        }
        searchResults.setTotalHits(topDocs.totalHits.value);
        searchResults.setTotalHitsRelation(topDocs.totalHits.relation);
        searchResults.setHits(hits);
    }

    private void collectFacets(SearchRequest searchRequest, IndexSearcher searcher, FacetsCollector fc, SearchResults searchResults) throws IOException {
        if (searchRequest.hasCounts()) {
            HashMap<String, Map<String, Number>> countsMap = new HashMap<String, Map<String, Number>>(searchRequest.getCounts().size());
            for (String string : searchRequest.getCounts()) {
                StringDocValuesReaderState state = new StringDocValuesReaderState(searcher.getIndexReader(), string);
                StringValueFacetCounts counts = new StringValueFacetCounts(state, fc);
                countsMap.put(string, this.collectFacets((Facets)counts, searchRequest.getTopN(), string));
            }
            searchResults.setCounts(countsMap);
        }
        if (searchRequest.hasRanges()) {
            HashMap<String, Map<String, Number>> rangesMap = new HashMap<String, Map<String, Number>>(searchRequest.getRanges().size());
            for (Map.Entry entry : searchRequest.getRanges().entrySet()) {
                DoubleRangeFacetCounts counts = this.toDoubleRangeFacetCounts(fc, (String)entry.getKey(), (List)entry.getValue());
                rangesMap.put((String)entry.getKey(), this.collectFacets((Facets)counts, searchRequest.getTopN(), (String)entry.getKey()));
            }
            searchResults.setRanges(rangesMap);
        }
    }

    private DoubleRangeFacetCounts toDoubleRangeFacetCounts(FacetsCollector fc, String field, List<DoubleRange> ranges) throws IOException {
        org.apache.lucene.facet.range.DoubleRange[] luceneRanges = new org.apache.lucene.facet.range.DoubleRange[ranges.size()];
        for (int i = 0; i < luceneRanges.length; ++i) {
            DoubleRange range = ranges.get(i);
            luceneRanges[i] = new org.apache.lucene.facet.range.DoubleRange(range.getLabel(), range.getMin() != null ? (Double)range.getMin() : Double.NEGATIVE_INFINITY, range.isMinInclusive(), range.getMax() != null ? (Double)range.getMax() : Double.POSITIVE_INFINITY, range.isMaxInclusive());
        }
        return new DoubleRangeFacetCounts(field, fc, luceneRanges);
    }

    private Map<String, Number> collectFacets(Facets facets, int topN, String dim) throws IOException {
        FacetResult topChildren = facets.getTopChildren(topN, dim, new String[0]);
        HashMap<String, Number> result = new HashMap<String, Number>(topChildren.childCount);
        for (LabelAndValue lv : topChildren.labelValues) {
            result.put(lv.label, lv.value);
        }
        return result;
    }

    private Sort toSort(SearchRequest searchRequest) {
        String last;
        if (!searchRequest.hasSort()) {
            return DEFAULT_SORT;
        }
        ArrayList<String> sort = new ArrayList<String>(searchRequest.getSort());
        switch (last = (String)sort.get(sort.size() - 1)) {
            case "-_id": 
            case "_id": {
                break;
            }
            default: {
                sort.add("_id");
            }
        }
        return this.convertSort(sort);
    }

    private Sort convertSort(List<String> sort) {
        SortField[] fields = new SortField[sort.size()];
        for (int i = 0; i < sort.size(); ++i) {
            fields[i] = this.convertSortField(sort.get(i));
        }
        return new Sort(fields);
    }

    private SortField convertSortField(String sortString) {
        if ("relevance".equals(sortString)) {
            return SortField.FIELD_SCORE;
        }
        Matcher m = SORT_FIELD_RE.matcher(sortString);
        if (!m.matches()) {
            throw new WebApplicationException(sortString + " is not a valid sort parameter", Response.Status.BAD_REQUEST);
        }
        boolean reverse = "-".equals(m.group(1));
        Lucene9IndexSchema.Type type = this.schema.getType(m.group(2));
        if (type == null) {
            return new UnknownSortField(m.group(2), reverse);
        }
        switch (type) {
            case STRING: {
                return new SortedSetSortField(m.group(2), reverse);
            }
            case DOUBLE: {
                return new SortedNumericSortField(m.group(2), SortField.Type.DOUBLE, reverse);
            }
        }
        throw new WebApplicationException("can't sort on field " + m.group(2), Response.Status.BAD_REQUEST);
    }

    private static Document toDocument(String docId, DocumentUpdateRequest request) throws IOException {
        Document result = new Document();
        result.add((IndexableField)new StringField("_id", docId, Field.Store.YES));
        result.add((IndexableField)new SortedDocValuesField("_id", new BytesRef((CharSequence)docId)));
        if (request.hasPartition()) {
            result.add((IndexableField)new StringField("_partition", request.getPartition(), Field.Store.NO));
        }
        CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
        for (Field field : request.getFields()) {
            Field f;
            if (field.getName().startsWith("_")) continue;
            if (field instanceof org.apache.couchdb.nouveau.api.TextField) {
                f = (org.apache.couchdb.nouveau.api.TextField)field;
                result.add((IndexableField)new TextField(f.getName(), ((org.apache.couchdb.nouveau.api.TextField)f).getValue(), ((org.apache.couchdb.nouveau.api.TextField)f).isStore() ? Field.Store.YES : Field.Store.NO));
                continue;
            }
            if (field instanceof org.apache.couchdb.nouveau.api.StringField) {
                f = (org.apache.couchdb.nouveau.api.StringField)field;
                result.add((IndexableField)new KeywordField(f.getName(), ((org.apache.couchdb.nouveau.api.StringField)f).getValue(), ((org.apache.couchdb.nouveau.api.StringField)f).isStore() ? Field.Store.YES : Field.Store.NO));
                continue;
            }
            if (field instanceof DoubleField) {
                f = (DoubleField)field;
                result.add((IndexableField)new org.apache.lucene.document.DoubleField(f.getName(), ((DoubleField)f).getValue().doubleValue(), ((DoubleField)f).isStore() ? Field.Store.YES : Field.Store.NO));
                continue;
            }
            if (field instanceof org.apache.couchdb.nouveau.api.StoredField) {
                f = (org.apache.couchdb.nouveau.api.StoredField)field;
                Object val = ((org.apache.couchdb.nouveau.api.StoredField)f).getValue();
                if (val instanceof String) {
                    result.add((IndexableField)new StoredField(f.getName(), (String)val));
                    continue;
                }
                if (val instanceof Number) {
                    result.add((IndexableField)new StoredField(f.getName(), ((Number)val).doubleValue()));
                    continue;
                }
                if (val instanceof byte[]) {
                    try {
                        CharBuffer buf = utf8Decoder.decode(ByteBuffer.wrap((byte[])val));
                        result.add((IndexableField)new StoredField(f.getName(), buf.toString()));
                    }
                    catch (CharacterCodingException e) {
                        result.add((IndexableField)new StoredField(f.getName(), (byte[])val));
                    }
                    continue;
                }
                throw new WebApplicationException(String.valueOf(field) + " is not valid", Response.Status.BAD_REQUEST);
            }
            throw new WebApplicationException(String.valueOf(field) + " is not valid", Response.Status.BAD_REQUEST);
        }
        return result;
    }

    private FieldDoc toFieldDoc(Object[] after) {
        Object[] fields = new Object[after.length];
        for (int i = 0; i < after.length; ++i) {
            if (after[i] instanceof PrimitiveWrapper) {
                fields[i] = ((PrimitiveWrapper)after[i]).getValue();
            }
            if (fields[i] instanceof byte[]) {
                fields[i] = new BytesRef((byte[])fields[i]);
            }
            if (!(fields[i] instanceof String)) continue;
            fields[i] = new BytesRef((CharSequence)((String)fields[i]));
        }
        return new FieldDoc(0, Float.NaN, fields);
    }

    private PrimitiveWrapper<?>[] toAfter(FieldDoc fieldDoc) {
        CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
        PrimitiveWrapper[] fields = new PrimitiveWrapper[fieldDoc.fields.length];
        for (int i = 0; i < fields.length; ++i) {
            if (fieldDoc.fields[i] instanceof String) {
                fields[i] = new StringWrapper((String)fieldDoc.fields[i]);
                continue;
            }
            if (fieldDoc.fields[i] instanceof BytesRef) {
                byte[] bytes = Lucene9Index.toBytes((BytesRef)fieldDoc.fields[i]);
                try {
                    CharBuffer buf = utf8Decoder.decode(ByteBuffer.wrap(bytes));
                    fields[i] = new StringWrapper(buf.toString());
                }
                catch (CharacterCodingException e) {
                    fields[i] = new ByteArrayWrapper(bytes);
                }
                continue;
            }
            if (fieldDoc.fields[i] instanceof Double) {
                fields[i] = new DoubleWrapper((double)((Double)fieldDoc.fields[i]));
                continue;
            }
            if (fieldDoc.fields[i] instanceof Integer) {
                fields[i] = new IntWrapper((int)((Integer)fieldDoc.fields[i]));
                continue;
            }
            if (fieldDoc.fields[i] instanceof Long) {
                fields[i] = new LongWrapper((long)((Long)fieldDoc.fields[i]));
                continue;
            }
            if (fieldDoc.fields[i] instanceof Float) {
                fields[i] = new FloatWrapper(((Float)fieldDoc.fields[i]).floatValue());
                continue;
            }
            if (fieldDoc.fields[i] == null) {
                fields[i] = new NullWrapper();
                continue;
            }
            throw new WebApplicationException(String.valueOf(fieldDoc.fields[i].getClass()) + " is not valid", Response.Status.BAD_REQUEST);
        }
        return fields;
    }

    private static byte[] toBytes(BytesRef bytesRef) {
        return Arrays.copyOfRange(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }

    private static Query docIdQuery(String docId) {
        return new TermQuery(Lucene9Index.docIdTerm(docId));
    }

    private static Term docIdTerm(String docId) {
        return new Term("_id", docId);
    }

    private Query parse(SearchRequest request) {
        Query result;
        Locale locale = request.getLocale() != null ? request.getLocale() : Locale.getDefault();
        Map<String, PointsConfig> pointsConfigMap = this.schema.toPointsConfigMap(locale);
        NouveauQueryParser queryParser = new NouveauQueryParser(this.analyzer, pointsConfigMap);
        try {
            result = queryParser.parse(request.getQuery(), "default");
            if (request.hasPartition()) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add((Query)new TermQuery(new Term("_partition", request.getPartition())), BooleanClause.Occur.MUST);
                builder.add(result, BooleanClause.Occur.MUST);
                result = builder.build();
            }
        }
        catch (QueryNodeException e) {
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.BAD_REQUEST);
        }
        return result;
    }

    private Lucene9IndexSchema initSchema(IndexWriter writer) {
        Iterable commitData = writer.getLiveCommitData();
        if (commitData == null) {
            return Lucene9IndexSchema.emptySchema();
        }
        for (Map.Entry entry : commitData) {
            if (!((String)entry.getKey()).equals("_schema")) continue;
            return Lucene9IndexSchema.fromString((String)entry.getValue());
        }
        return Lucene9IndexSchema.emptySchema();
    }

    public String toString() {
        return "Lucene9Index [analyzer=" + String.valueOf(this.analyzer) + ", writer=" + String.valueOf(this.writer) + ", searcherManager=" + String.valueOf(this.searcherManager) + "]";
    }

    private static final class UnknownSortField
    extends SortField {
        private static final FieldComparatorSource COMPARATOR = new FieldComparatorSource(){

            public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
                return new FieldComparator<Void>(){

                    public int compare(int slot1, int slot2) {
                        return 0;
                    }

                    public void setTopValue(Void value) {
                    }

                    public Void value(int slot) {
                        return null;
                    }

                    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                        return new LeafFieldComparator(){

                            public void setBottom(int slot) throws IOException {
                            }

                            public int compareBottom(int doc) throws IOException {
                                return 0;
                            }

                            public int compareTop(int doc) throws IOException {
                                return 0;
                            }

                            public void copy(int slot, int doc) throws IOException {
                            }

                            public void setScorer(Scorable scorer) throws IOException {
                            }
                        };
                    }
                };
            }
        };

        private UnknownSortField(String fieldName, boolean reverse) {
            super(fieldName, COMPARATOR, reverse);
        }
    }
}

