/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.lucene9;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.couchdb.nouveau.api.DoubleField;
import org.apache.couchdb.nouveau.api.Field;
import org.apache.couchdb.nouveau.api.StoredField;
import org.apache.couchdb.nouveau.api.StringField;
import org.apache.couchdb.nouveau.api.TextField;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;

final class Lucene9IndexSchema {
    private final ConcurrentMap<String, Type> map;

    private Lucene9IndexSchema(Map<String, Type> map) {
        this.map = new ConcurrentHashMap<String, Type>(map);
        this.map.put("_id", Type.STRING);
    }

    public static Lucene9IndexSchema emptySchema() {
        return new Lucene9IndexSchema(new HashMap<String, Type>());
    }

    public static Lucene9IndexSchema fromString(String schemaStr) {
        Objects.requireNonNull(schemaStr);
        if (schemaStr.isEmpty()) {
            return Lucene9IndexSchema.emptySchema();
        }
        Map<String, Type> map = Arrays.stream(schemaStr.split(",")).collect(Collectors.toMap(i -> i.split(":")[0], i -> Type.valueOf(i.split(":")[1])));
        return new Lucene9IndexSchema(map);
    }

    public void update(Collection<Field> fields) {
        Objects.requireNonNull(fields);
        for (Field field : fields) {
            this.map.putIfAbsent(field.getName(), Type.fromField(field));
            this.assertType(field);
        }
    }

    public Type getType(String fieldName) {
        return (Type)((Object)this.map.get(fieldName));
    }

    public void assertType(Field field) {
        Objects.requireNonNull(field);
        Type expectedType = Type.fromField(field);
        Type actualType = (Type)((Object)this.map.get(field.getName()));
        if (actualType == null) {
            throw new WebApplicationException("Unknown field " + field.getName(), Response.Status.BAD_REQUEST);
        }
        if (expectedType != actualType) {
            throw new WebApplicationException(String.format("field %s is of type %s not %s", new Object[]{field.getName(), expectedType, actualType}), Response.Status.BAD_REQUEST);
        }
    }

    public Map<String, PointsConfig> toPointsConfigMap(Locale locale) {
        Objects.requireNonNull(locale);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        PointsConfig doublePointsConfig = new PointsConfig(numberFormat, Double.class);
        return this.map.entrySet().stream().filter(e -> e.getValue() == Type.DOUBLE).collect(Collectors.toMap(e -> (String)e.getKey(), e -> doublePointsConfig));
    }

    public String toString() {
        return this.map.entrySet().stream().map(e -> String.format("%s:%s", e.getKey(), e.getValue())).collect(Collectors.joining(","));
    }

    public static enum Type {
        STRING,
        TEXT,
        DOUBLE,
        STORED;


        private static Type fromField(Field field) {
            if (field instanceof StringField) {
                return STRING;
            }
            if (field instanceof TextField) {
                return TEXT;
            }
            if (field instanceof DoubleField) {
                return DOUBLE;
            }
            if (field instanceof StoredField) {
                return STORED;
            }
            throw new IllegalArgumentException(String.valueOf(field) + " not supported");
        }
    }
}

