/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.ResponseMetered;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.couchdb.nouveau.api.AnalyzeRequest;
import org.apache.couchdb.nouveau.api.AnalyzeResponse;
import org.apache.couchdb.nouveau.lucene9.Lucene9AnalyzerFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

@Path(value="/analyze")
@Metered
@ResponseMetered
@ExceptionMetered(cause=IOException.class)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class AnalyzeResource {
    @POST
    public AnalyzeResponse analyzeText(@NotNull @Valid AnalyzeRequest request) throws IOException {
        try {
            List<String> tokens = this.tokenize(Lucene9AnalyzerFactory.newAnalyzer(request.getAnalyzer()), request.getText());
            return new AnalyzeResponse(tokens);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(request.getAnalyzer() + " not a valid analyzer", Response.Status.BAD_REQUEST);
        }
    }

    private List<String> tokenize(Analyzer analyzer, String text) throws IOException {
        ArrayList<String> result = new ArrayList<String>(10);
        try (TokenStream tokenStream = analyzer.tokenStream("default", text);){
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                CharTermAttribute term = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                result.add(term.toString());
            }
            tokenStream.end();
        }
        return result;
    }
}

