/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.Module;
import io.dropwizard.core.Application;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.couchdb.nouveau.NouveauApplicationConfiguration;
import org.apache.couchdb.nouveau.core.IndexManager;
import org.apache.couchdb.nouveau.core.UserAgentFilter;
import org.apache.couchdb.nouveau.health.AnalyzeHealthCheck;
import org.apache.couchdb.nouveau.health.IndexHealthCheck;
import org.apache.couchdb.nouveau.lucene9.Lucene9Module;
import org.apache.couchdb.nouveau.lucene9.ParallelSearcherFactory;
import org.apache.couchdb.nouveau.resources.AnalyzeResource;
import org.apache.couchdb.nouveau.resources.IndexResource;
import org.apache.couchdb.nouveau.tasks.CloseAllIndexesTask;

public class NouveauApplication
extends Application<NouveauApplicationConfiguration> {
    public static void main(String[] args) throws Exception {
        new NouveauApplication().run(args);
    }

    @Override
    public String getName() {
        return "Nouveau";
    }

    @Override
    public void run(NouveauApplicationConfiguration configuration, Environment environment) throws Exception {
        environment.servlets().addFilter("UserAgentFilter", (Filter)new UserAgentFilter()).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        IndexManager indexManager = new IndexManager();
        indexManager.setCommitIntervalSeconds(configuration.getCommitIntervalSeconds());
        indexManager.setIdleSeconds(configuration.getIdleSeconds());
        indexManager.setMaxIndexesOpen(configuration.getMaxIndexesOpen());
        ScheduledExecutorService schedulerExecutorService = environment.lifecycle().scheduledExecutorService("index-manager-%d").threads(configuration.getSchedulerThreadCount()).build();
        indexManager.setScheduledExecutorService(schedulerExecutorService);
        indexManager.setSearcherFactory(new ParallelSearcherFactory(ForkJoinPool.commonPool()));
        indexManager.setObjectMapper(environment.getObjectMapper());
        indexManager.setRootDir(configuration.getRootDir());
        environment.lifecycle().manage((Managed)indexManager);
        environment.getObjectMapper().registerModule((Module)new Lucene9Module());
        AnalyzeResource analyzeResource = new AnalyzeResource();
        environment.jersey().register((Object)analyzeResource);
        IndexResource indexResource = new IndexResource(indexManager);
        environment.jersey().register((Object)indexResource);
        environment.healthChecks().register("analyze", (HealthCheck)new AnalyzeHealthCheck(analyzeResource));
        environment.healthChecks().register("index", (HealthCheck)new IndexHealthCheck(indexResource));
        environment.admin().addTask(new CloseAllIndexesTask(indexManager));
        environment.jersey().register((Object)new OpenApiResource());
    }
}

