/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Collection;
import org.apache.couchdb.nouveau.api.Field;

public final class DocumentUpdateRequest {
    @PositiveOrZero
    private final long matchSeq;
    @Positive
    private final long seq;
    private final String partition;
    @NotEmpty
    @Valid
    private final Collection<Field> fields;

    public DocumentUpdateRequest(@JsonProperty(value="match_seq") long matchSeq, @JsonProperty(value="seq") long seq, @JsonProperty(value="partition") String partition, @JsonProperty(value="fields") Collection<Field> fields) {
        this.matchSeq = matchSeq;
        this.seq = seq;
        this.partition = partition;
        this.fields = fields;
    }

    public long getMatchSeq() {
        return this.matchSeq;
    }

    public long getSeq() {
        return this.seq;
    }

    public String getPartition() {
        return this.partition;
    }

    public boolean hasPartition() {
        return this.partition != null;
    }

    public Collection<Field> getFields() {
        return this.fields;
    }

    public String toString() {
        return "DocumentUpdateRequest [matchSeq=" + this.matchSeq + ", seq=" + this.seq + ", partition=" + this.partition + ", fields=" + String.valueOf(this.fields) + "]";
    }
}

