/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.couchdb.nouveau.api.DoubleRange;
import org.apache.couchdb.nouveau.core.ser.PrimitiveWrapper;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class SearchRequest {
    @NotNull
    private String query;
    @PositiveOrZero
    private long minUpdateSeq;
    @PositiveOrZero
    private long minPurgeSeq;
    private Locale locale;
    private String partition;
    @Positive
    private int limit = 25;
    private List<@NotEmpty String> sort;
    private List<@NotEmpty String> counts;
    private Map<@NotEmpty String, List<@NotNull DoubleRange>> ranges;
    private PrimitiveWrapper<?>[] after;
    @Min(value=1L)
    @Max(value=1000L)
    private @Min(value=1L) @Max(value=1000L) int topN = 10;

    public void setQuery(String query) {
        this.query = query;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    public void setMinUpdateSeq(long minUpdateSeq) {
        this.minUpdateSeq = minUpdateSeq;
    }

    @JsonProperty
    public long getMinUpdateSeq() {
        return this.minUpdateSeq;
    }

    public void setMinPurgeSeq(long minPurgeSeq) {
        this.minPurgeSeq = minPurgeSeq;
    }

    @JsonProperty
    public long getMinPurgeSeq() {
        return this.minPurgeSeq;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    @JsonProperty
    public String getPartition() {
        return this.partition;
    }

    public boolean hasPartition() {
        return this.partition != null;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    public boolean hasSort() {
        return this.sort != null;
    }

    @JsonProperty
    public List<String> getSort() {
        return this.sort;
    }

    public void setSort(List<String> sort) {
        this.sort = sort;
    }

    public boolean hasCounts() {
        return this.counts != null;
    }

    public void setCounts(List<String> counts) {
        this.counts = counts;
    }

    @JsonProperty
    public List<String> getCounts() {
        return this.counts;
    }

    public boolean hasRanges() {
        return this.ranges != null;
    }

    public void setRanges(Map<String, List<DoubleRange>> ranges) {
        this.ranges = ranges;
    }

    @JsonProperty
    public Map<String, List<DoubleRange>> getRanges() {
        return this.ranges;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    @JsonProperty
    public int getTopN() {
        return this.topN;
    }

    public void setAfter(PrimitiveWrapper<?>[] after) {
        this.after = after;
    }

    @JsonProperty
    public PrimitiveWrapper<?>[] getAfter() {
        return this.after;
    }

    public String toString() {
        return "SearchRequest [query=" + this.query + ", min_update_seq=" + this.minUpdateSeq + ", min_purge_seq=" + this.minPurgeSeq + ", locale=" + String.valueOf(this.locale) + ", sort=" + String.valueOf(this.sort) + ", limit=" + this.limit + ", after=" + String.valueOf(this.after) + ", counts=" + String.valueOf(this.counts) + ", ranges=" + String.valueOf(this.ranges) + "]";
    }
}

