/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.lucene9;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class QueryDeserializer
extends StdDeserializer<Query> {
    public QueryDeserializer() {
        this(null);
    }

    public QueryDeserializer(Class<?> vc) {
        super(vc);
    }

    public Query deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        return this.deserializeNode(parser, context, (JsonNode)parser.getCodec().readTree(parser));
    }

    private Query deserializeNode(JsonParser parser, DeserializationContext context, JsonNode node) throws IOException, JsonProcessingException {
        String type;
        switch (type = this.get(parser, node, "@type").asText()) {
            case "term": {
                String field = this.get(parser, node, "field").asText();
                String text = this.get(parser, node, "text").asText();
                return new TermQuery(new Term(field, text));
            }
            case "boolean": {
                if (!this.get(parser, node, "clauses").isArray()) {
                    throw new JsonParseException(parser, "boolean clauses must be an array");
                }
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                Iterator it = this.get(parser, node, "clauses").elements();
                while (it.hasNext()) {
                    Query q = this.deserializeNode(parser, context, (JsonNode)it.next());
                    builder.add(q, null);
                }
                return builder.build();
            }
            case "wildcard": {
                String field = this.get(parser, node, "field").asText();
                String text = this.get(parser, node, "text").asText();
                return new WildcardQuery(new Term(field, text));
            }
            case "phrase": {
                String field = this.get(parser, node, "field").asText();
                if (!this.get(parser, node, "terms").isArray()) {
                    throw new JsonParseException(parser, "phrase terms must be an array");
                }
                PhraseQuery.Builder builder = new PhraseQuery.Builder();
                Iterator it = this.get(parser, node, "terms").elements();
                while (it.hasNext()) {
                    builder.add(new Term(field, ((JsonNode)it.next()).asText()));
                }
                builder.setSlop(this.getInt(parser, node, "slop", 0));
                return builder.build();
            }
            case "prefix": {
                String field = this.get(parser, node, "field").asText();
                String text = this.get(parser, node, "text").asText();
                return new PrefixQuery(new Term(field, text));
            }
            case "fuzzy": {
                String field = this.get(parser, node, "field").asText();
                String text = this.get(parser, node, "text").asText();
                int maxEdits = this.getInt(parser, node, "max_edits", 2);
                int prefixLength = this.getInt(parser, node, "prefix_length", 0);
                return new FuzzyQuery(new Term(field, text), maxEdits, prefixLength);
            }
            case "regexp": {
                String field = this.get(parser, node, "field").asText();
                String text = this.get(parser, node, "text").asText();
                return new RegexpQuery(new Term(field, text));
            }
            case "term_range": 
            case "point_range": 
            case "match_all": {
                return new MatchAllDocsQuery();
            }
        }
        throw new JsonParseException(parser, type + " not a supported query type");
    }

    private JsonNode get(JsonParser parser, JsonNode node, String key) throws JsonParseException {
        if (node.hasNonNull(key)) {
            return node.get(key);
        }
        throw new JsonParseException(parser, key + " is required");
    }

    private int getInt(JsonParser parser, JsonNode node, String key, int defaultValue) throws JsonParseException {
        if (node.hasNonNull(key)) {
            if (node.get(key).isInt()) {
                return node.get(key).asInt();
            }
            throw new JsonParseException(parser, key + " must be an int");
        }
        return defaultValue;
    }
}

