/*
 * Decompiled with CFR 0.152.
 */
package org.apache.couchdb.nouveau.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.ResponseMetered;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.couchdb.nouveau.api.DocumentDeleteRequest;
import org.apache.couchdb.nouveau.api.DocumentUpdateRequest;
import org.apache.couchdb.nouveau.api.IndexDefinition;
import org.apache.couchdb.nouveau.api.IndexInfo;
import org.apache.couchdb.nouveau.api.IndexInfoRequest;
import org.apache.couchdb.nouveau.api.Ok;
import org.apache.couchdb.nouveau.api.SearchRequest;
import org.apache.couchdb.nouveau.api.SearchResults;
import org.apache.couchdb.nouveau.core.IndexManager;

@Path(value="/index/{name}")
@Metered
@ResponseMetered
@ExceptionMetered(cause=IOException.class)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class IndexResource {
    private final IndexManager indexManager;

    public IndexResource(IndexManager indexManager) {
        this.indexManager = Objects.requireNonNull(indexManager);
    }

    @PUT
    public Ok createIndex(@PathParam(value="name") String name, @NotNull @Valid IndexDefinition indexDefinition) throws IOException {
        this.indexManager.create(name, indexDefinition);
        return Ok.INSTANCE;
    }

    @DELETE
    @Path(value="/doc/{docId}")
    public Ok deleteDoc(@PathParam(value="name") String name, @PathParam(value="docId") String docId, @NotNull @Valid DocumentDeleteRequest request) throws Exception {
        return this.indexManager.with(name, index -> {
            index.delete(docId, request);
            return Ok.INSTANCE;
        });
    }

    @DELETE
    public Ok deletePath(@PathParam(value="name") String path, @Valid List<String> exclusions) throws IOException {
        this.indexManager.deleteAll(path, exclusions);
        return Ok.INSTANCE;
    }

    @GET
    public IndexInfo getIndexInfo(@PathParam(value="name") String name) throws Exception {
        return this.indexManager.with(name, index -> index.info());
    }

    @POST
    public Ok setIndexInfo(@PathParam(value="name") String name, @NotNull @Valid IndexInfoRequest request) throws Exception {
        return this.indexManager.with(name, index -> {
            if (request.getMatchUpdateSeq().isPresent() && request.getUpdateSeq().isPresent()) {
                index.setUpdateSeq(request.getMatchUpdateSeq().getAsLong(), request.getUpdateSeq().getAsLong());
            }
            if (request.getMatchPurgeSeq().isPresent() && request.getPurgeSeq().isPresent()) {
                index.setPurgeSeq(request.getMatchPurgeSeq().getAsLong(), request.getPurgeSeq().getAsLong());
            }
            return Ok.INSTANCE;
        });
    }

    @POST
    @Path(value="/search")
    public SearchResults searchIndex(@PathParam(value="name") String name, @NotNull @Valid SearchRequest request) throws Exception {
        return this.indexManager.with(name, index -> index.search(request));
    }

    @PUT
    @Path(value="/doc/{docId}")
    public Ok updateDoc(@PathParam(value="name") String name, @PathParam(value="docId") String docId, @NotNull @Valid DocumentUpdateRequest request) throws Exception {
        return this.indexManager.with(name, index -> {
            index.update(docId, request);
            return Ok.INSTANCE;
        });
    }
}

